// columns.js
import { FiEdit, FiTrash2 } from "react-icons/fi";
import { Tooltip } from "react-tooltip";

export const getBookChapterColumns = (router, handleDelete) => [
  {
    label: "S.No",
    name: "S.No",
    cell: (row, index) => index + 1,
    // width: "60px",
  },
  {
    label: "Book Title",
    name: "Book Title",
    selector: (row) => row.book.book_title,
    // styleTypeUiPatterns: 'badge',
    // styleTypeColors: 'dark',
  },
  {
    label: "Manuscript ID",
    name: "Manuscript ID",
    selector: (row) => row.chap_manuscriptID,
    // styleTypeUiPatterns: 'badge',
    // styleTypeColors: 'info',
  },
  {
    label: "Chapter Title",
    name: "Chapter Title",
    selector: (row) => row.chap_title,
    styleTypeUiPatterns: "badge",
  },
  {
    label: "Word Count",
    name: "Word Count",
    selector: (row) => row.chap_wordcount,
    styleTypeUiPatterns: "badge",
  },
  {
    label: "Author",
    name: "Author",
    cell: (row) => `${row.chap_firstName} ${row.chap_lastName}`,
    styleTypeUiPatterns: "badge",
  },
  {
    label: "Email",
    name: "Email",
    selector: (row) => row.chap_corresAuEmail,
    // styleTypeUiPatterns: 'badge',
    // styleTypeIcons: 'mailIcon',
    // styleTypeColors: 'info',
  },
  {
    label: "Status",
    name: "Status",
    selector: (row) => row.chap_status,
    styleTypeUiPatterns: "badge",
  },
  {
    label: "P+ Status",
    name: "P+ Status",
    selector: (row) => row.pstatus?.pstatus_name || "",
    styleTypeUiPatterns: "badge",
  },
  {
    label: "Due Date",
    name: "Due Date",
    selector: (row) => row.chap_pdueDate,
    styleTypeUiPatterns: "badge",
  },
  {
    label: "Copy Editing",
    name: "Copy Editing",
    selector: (row) => row.chap_copyEditing,
     styleTypeUiPatterns: "badge",
    styleTypeColors: "warning",
  },
  {
    label: "Comments",
    name: "Comments",
    selector: (row) => row.chap_comments,
    grow: 2,
    wrap: true,
  },

];
